<?php

/**
 * @file plugins/generic/reviewerCredits/ReviewerCreditsReportDAO.inc.php
 *
 * Copyright (c) 2014-2020 Simon Fraser University
 * Copyright (c) 2003-2020 John Willinsky
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * @class ReviewerCreditsReportDAO
 * @ingroup plugins_reports_review
 * @see ReviewReportPlugin
 *
 * @brief Review report DAO
 */

import('lib.pkp.classes.submission.SubmissionComment');

class ReviewerCreditsReportDAO extends DAO {
	/**
	 * Get the review report data.
	 * @param $contextId int Context ID
	 * @return array
	 */
	function getReviewReport($contextId) {
		$locale = AppLocale::getLocale();

		$commentsReturner = $this->retrieve(
			'SELECT	DISTINCT sc.submission_id,
				sc.comments,
				sc.author_id,
				r.review_id
			FROM	submission_comments sc
				JOIN submissions s ON (s.submission_id = sc.submission_id)
				JOIN review_assignments r ON ( sc.assoc_id = r.review_id )
			WHERE	comment_type = ?
				AND s.context_id = ? AND sc.viewable = 1',
			[COMMENT_TYPE_PEER_REVIEW, (int) $contextId]
		);

		$comments    = array();
		if ( $commentsReturner instanceof ADORecordSet ) {   //3.2 returns ADORecordSet
			foreach ( $commentsReturner as $result ) {
				$row                = "";
				$row->submission_id = $result['submission_id'];
				$row->comments     = $result['comments'];
				$row->author_id      = $result['author_id'];
				$row->review_id  = $result['review_id'];
				$comments[]             = $row;
			}
		} else {
			$comments = iterator_to_array( $commentsReturner );
		}

		$userDao = DAORegistry::getDAO('UserDAO');
		$site = ( new Application )->getRequest()->getSite();
		$sitePrimaryLocale = $site->getPrimaryLocale();

		$reviewsReturner = $this->retrieve(
			'SELECT	
				r.review_id as review_id,
				a.submission_id AS submission_id,
				u.user_id AS reviewer_id,
				' . $userDao->getFetchColumns() .',
				r.date_due AS date_due,
				r.date_response_due AS date_response_due,
				r.date_completed AS date_completed,
				r.recommendation AS recommendation
			FROM	review_assignments r
				LEFT JOIN submissions a ON r.submission_id = a.submission_id
				LEFT JOIN users u ON (u.user_id = r.reviewer_id)
				' . $userDao->getFetchJoins() .'
				LEFT JOIN user_settings uas ON (u.user_id = uas.user_id AND uas.setting_name = ? AND uas.locale = a.locale)
				LEFT JOIN user_settings uasl ON (u.user_id = uasl.user_id AND uasl.setting_name = ? AND uasl.locale = ?)
				LEFT JOIN user_settings us ON (u.user_id = us.user_id AND us.setting_name = ?)
			WHERE	 a.context_id = ?
			ORDER BY review_id DESC',
			array_merge(
				$userDao->getFetchParameters(),
				[
					'affiliation',
					'affiliation',
					$sitePrimaryLocale,
					'orcid',
					(int) $contextId
				]
			)
		);

		$reviews    = array();
		if ( $reviewsReturner instanceof ADORecordSet ) {   //3.2 returns ADORecordSet
			foreach ( $reviewsReturner as $result ) {
				$row                = "";
				$row->review_id = $result['review_id'];
				$row->submission     = $result['submission'];
				$row->submission_id      = $result['submission_id'];
				$row->reviewer_id  = $result['reviewer_id'];
				$row->date_due  = $result['date_due'];
				$row->date_response_due  = $result['date_response_due'];
				$row->recommendation  = $result['recommendation'];
				$row->date_completed  = $result['date_completed'];
				$row->date_completed  = $result['date_completed'];
				$row->user_family  = $result['user_family'];
				$row->user_given  = $result['user_given'];
				$reviews[]             = $row;
			}
		} else {
			$reviews = iterator_to_array( $reviewsReturner );
		}

		return [$comments, $reviews];
	}
}
