<?php

use Illuminate\Events\Dispatcher;
use PKP\observers\events\DecisionAdded;

class EditorialDecisionListener
{


    public function subscribe(Dispatcher $events): void
    {
        $events->listen(
            DecisionAdded::class,
            [self::class, 'handleDecisionAdded']
        );
    }

    public function handleDecisionAdded(DecisionAdded $event)
    {
        $plugin = PKP\plugins\PluginRegistry::getPlugin('generic', 'reviewercreditsplugin');
        $plugin->callbackSendEditorDecision(null, null, $event);
    }


}
