<?php

/**
 * @file plugins/generic/reviewerCredits/ReviewerCreditsReportDAO.inc.php
 *
 * Copyright (c) 2014-2020 Simon Fraser University
 * Copyright (c) 2003-2020 John Willinsky
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * @class ReviewerCreditsReportDAO
 * @ingroup plugins_reports_review
 * @see ReviewReportPlugin
 *
 * @brief Review report DAO
 */

require_once 'ReviewerCreditsVersionCheck.php';

if ( ! isNewVersion() ) {
	import( 'lib.pkp.classes.submission.SubmissionComment' );
} else {
	require_once 'dynamicClasses/ReviewerCreditsEditorialDecisionReportDAO.inc.classes.php';
}


class ReviewerCreditsEditorialDecisionReportDAO extends DAO {
	/**
	 * Get the review report data.
	 *
	 * @param $contextId int Context ID
	 *
	 * @return array
	 */
	function getEditorialDecisionReport( $contextId ) {
		$results = $this->retrieve(
			'SELECT	submission_id, editor_id, decision, stage_id, round, 
				date_decided
			FROM	edit_decisions
			WHERE	submission_id in (select submission_id from submissions where context_id = ?)
				ORDER BY date_decided DESC', [ $contextId ]
		);
		$rows    = array();
		if ( $results instanceof ADORecordSet ) {   //3.2 returns ADORecordSet
			foreach ( $results as $result ) {
				$row                = "";
				$row->submission_id = $result['submission_id'];
				$row->editor_id     = $result['editor_id'];
				$row->decision      = $result['decision'];
				$row->stage_id      = $result['stage_id'];
				$row->round      = $result['round'];
				$row->date_decided  = $result['date_decided'];
				$rows[]             = $row;
			}
		} else {
			$rows = iterator_to_array( $results );
		}

		return $rows;
	}
}
