<?php

/**
 * @file plugins/generic/reviewerCredits/ReviewerCreditsVersionCheck.php
 *
 * Copyright (c) 2015-2018 University of Pittsburgh
 * Copyright (c) 2014-2018 Simon Fraser University
 * Copyright (c) 2003-2018 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * @class ReviewerCreditsPlugin
 * @ingroup plugins_generic_reviewerCredits
 *
 * @brief ReviewerCredits plugin class
 */


if ( ! isNewVersion() ) {
	import( 'lib.pkp.classes.plugins.GenericPlugin' );
} else {
	require_once 'dynamicClasses/ReviewerCredits.inc.classes.php';
}

/**
 * Check OJS version compatibility and log the version.
 * @return bool
 */
function isNewVersion() {
	$versionDao = DAORegistry::getDAO('VersionDAO'); /** @var VersionDAO $versionDao */
	$currentVersion = $versionDao->getCurrentVersion();
	$currentVersionString = $currentVersion->getVersionString();

	// check if the version is over or equal to 3.4.0
	if (version_compare($currentVersionString, '3.4.0', '<')) {
		//error_log('ReviewerCredits plugin is not compatible with OJS version ' . $currentVersionString);
		return false;
	}

	return true;
}